/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.manager;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public class AnimatableManager<T extends GeoAnimatable> {
    protected final Map<String, AnimationController<T>> animationControllers;
    protected final Supplier<Map<DataTicket<?>, Object>> animatableInstanceData = Suppliers.memoize(Reference2ObjectOpenHashMap::new);
    protected double firstRenderTick = 0.0;

    public AnimatableManager(GeoAnimatable animatable) {
        ControllerRegistrar registrar = new ControllerRegistrar((List<AnimationController<? extends GeoAnimatable>>)new ObjectArrayList(1));
        animatable.registerControllers(registrar);
        this.animationControllers = registrar.build();
    }

    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.animationControllers;
    }

    public void addController(AnimationController<T> controller) {
        this.getAnimationControllers().put(controller.getName(), controller);
    }

    public void removeController(String name) {
        this.getAnimationControllers().remove(name);
    }

    public <D> void setAnimatableData(DataTicket<D> dataTicket, D data) {
        this.animatableInstanceData.get().put(dataTicket, data);
    }

    public <D> @Nullable D getAnimatableData(DataTicket<D> dataTicket) {
        return (D)this.animatableInstanceData.get().get(dataTicket);
    }

    public void tryTriggerAnimation(String animName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (!controller.triggerAnimation(animName)) continue;
            return;
        }
    }

    public void tryTriggerAnimation(String controllerName, String animName) {
        AnimationController<T> controller = this.getAnimationControllers().get(controllerName);
        if (controller != null) {
            controller.triggerAnimation(animName);
        }
    }

    public void stopTriggeredAnimation(@Nullable String animName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (animName != null && !controller.isTriggeredAnimation(animName) || !controller.stopTriggeredAnimation()) continue;
            return;
        }
    }

    public void stopTriggeredAnimation(String controllerName, @Nullable String animName) {
        AnimationController<T> controller = this.getAnimationControllers().get(controllerName);
        if (controller != null && (animName == null || controller.isTriggeredAnimation(animName))) {
            controller.stopTriggeredAnimation();
        }
    }

    public void markRenderedAt(double animatableTick) {
        if (this.firstRenderTick > animatableTick) {
            this.firstRenderTick = animatableTick;
        }
    }

    public double getFirstRenderTick() {
        return this.firstRenderTick;
    }

    public record ControllerRegistrar(List<AnimationController<? extends GeoAnimatable>> controllers) {
        public ControllerRegistrar add(AnimationController<?> ... controllers) {
            this.controllers().addAll(Arrays.asList(controllers));
            return this;
        }

        public ControllerRegistrar add(AnimationController<?> controller) {
            this.controllers().add(controller);
            return this;
        }

        public ControllerRegistrar remove(String name) {
            this.controllers().removeIf(controller -> controller.getName().equals(name));
            return this;
        }

        @ApiStatus.Internal
        private <T extends GeoAnimatable> Map<String, AnimationController<T>> build() {
            Object2ObjectArrayMap map = new Object2ObjectArrayMap(this.controllers().size());
            this.controllers().forEach(controller -> map.put((Object)controller.getName(), controller));
            return map;
        }
    }
}

